/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.transition.sentry;

import java.util.HashMap;
import java.util.Map;

public final class SentryTagResolver {
    private static final Map<String, String> MAPPINGS = new HashMap<String, String>();

    public static String findSuspectMod(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            for (StackTraceElement e : t.getStackTrace()) {
                String name = e.getClassName();
                for (Map.Entry<String, String> entry : MAPPINGS.entrySet()) {
                    if (!name.startsWith(entry.getKey())) continue;
                    return entry.getValue();
                }
            }
        }
        return "UnknownMod";
    }

    private SentryTagResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MAPPINGS.put("dev.tr7zw.transition", "TRansition");
        MAPPINGS.put("dev.tr7zw.entityculling", "EntityCulling");
        MAPPINGS.put("com.logisticscraft.occlusionculling", "EntityCulling");
        MAPPINGS.put("dev.tr7zw.skinlayers", "3dSkinLayers");
        MAPPINGS.put("dev.tr7zw.armorlayers", "3dArmorLayers");
        MAPPINGS.put("dev.tr7zw.waveycapes", "WaveyCapes");
        MAPPINGS.put("dev.tr7zw.notenoughanimations", "NotEnoughAnimations");
        MAPPINGS.put("dev.tr7zw.firstperson", "FirstpersonMod");
        MAPPINGS.put("dev.tr7zw.exordium", "Exordium");
        MAPPINGS.put("dev.tr7zw.itemswapper", "ItemSwapper");
        MAPPINGS.put("dev.tr7zw.disguiseheads", "DisguiseHeads");
        MAPPINGS.put("dev.tr7zw.graphutil", "GraphUtil");
        MAPPINGS.put("dev.tr7zw.paperdoll", "PaperDoll");
        MAPPINGS.put("dev.tr7zw.modeldumper", "ModelDumper");
    }
}

